#!/bin/bash
# upproperties.sh OLDBG.properties NEWENG.properties

LC_CTYPE=en_US.UTF-8
LC_COLLATE=en_US.UTF-8
LC_TIME=en_US.UTF-8
LC_NUMERIC=en_US.UTF-8
LC_MONETARY=en_US.UTF-8
LC_MESSAGES=en_US.UTF-8
LANG=en_US.UTF-8

export LC_CTYPE LC_COLLATE LC_TIME LC_NUMERIC LC_MONETARY LC_MESSAGES LANG

BGFILE=$1
ENFILE=$2

TRANSLATABLE="^[^#].*="

# DEBUG
# cat $BGFILE > BGFILE
# cat $ENFILE > ENFILE

BGTMP=`mktemp`

ENMID=`mktemp`
ENTMP=`mktemp`

# Проверка за разделител
SEPARATOR='|'

grep "$SEPARATOR" $BGTMP

if [ x$? != 'x1' ]; then
    echo "$BGTMP не се чете или съдържа $SEPARATOR"
    exit 1;
fi

grep "$SEPARATOR" $ENTMP

if [ x$? != 'x1' ]; then
    echo "$ENTMP не се чете или съдържа $SEPARATOR"
    exit 1;
fi

# Отделяме съдържащите „=“, които не започват
# с „#“ , заменяме 1-то „=“ с „|“,
# подреждаме по първото поле.
cat $BGFILE |\
dos2unix |\
grep "$TRANSLATABLE" |\
sed "s/=/$SEPARATOR/" |\
sort -t "$SEPARATOR" -k 1,1 > $BGTMP


# DEBUG
# cat $BGTMP > BGTMP

# Номерираме, слагаме номера накрая на реда,
cat $ENFILE |\
dos2unix |\
nl -ba |\
sed "s/^[ ]*\([0-9][0-9]*\)[\t]*\(.*\)$/\2$SEPARATOR\1/" > $ENMID

# DEBUG
# cat $ENMID > ENMID

# Отделяме съдържащите „=“, които не започват с „#“,
# заменяме 1-то „=“ с „|“,  подреждаме по първото поле.
cat $ENMID |\
grep "$TRANSLATABLE" |\
sed "s/=/$SEPARATOR/" |\
sort -t "$SEPARATOR" -k 1,1 > $ENTMP

# DEBUG
# cat $ENTMP > ENTMP

RESTMP=`mktemp`
RESTMP1=`mktemp`

# join по първото поле, разделител "$SEPARATOR"
# изход ТЕРМИН|АНГЛИЙСКИ|БЪЛГАРСКИ или BUGABUGA|НОМЕР
# заменяме |АНГЛИЙСКИ|BUGABUGA с |АНГЛИЙСКИ|АНГЛИЙСКИ|
join $ENTMP $BGTMP  -t "$SEPARATOR" -j 1 -o 1.1,1.2,2.2,1.3 -a 1 -e 'BUGABUGA' |\
sed "s/$SEPARATOR\([^$SEPARATOR]*\)$SEPARATOR""BUGABUGA/$SEPARATOR\1$SEPARATOR\1/" > $RESTMP

# DEBUG
# cat $RESTMP > RESTMP

# Преподреждаме ТЕРМИН|БЪЛГАРСКИ|НОМЕР
# Първия | става =
# Резултат НЕЩО|НОМЕР
cat $RESTMP |\
cut -d "$SEPARATOR" -f 4,1,3 |\
sed "s/$SEPARATOR/=/" > $RESTMP1

# DEBUG
# cat $RESTMP1 > RESTMP1-1

# Добявяме останалите редове
# Резултат НЕЩО|НОМЕР
cat $ENMID |\
grep -v "$TRANSLATABLE" |\
cut -d "$SEPARATOR" -f 2,1 >> $RESTMP1

# DEBUG
# cat $RESTMP1 > RESTMP1-2

# Сортираме по второто поле
# Взимаме първото, ура
sort -t "$SEPARATOR" -k 2,2 -n $RESTMP1 |\
cut -d  "$SEPARATOR" -f 1 

rm $BGTMP $ENTMP $RESTMP $RESTMP1
