<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:math="http://exslt.org/math" 
xmlns:dyn="http://exslt.org/dynamic"
xmlns:str="http://exslt.org/strings"

extension-element-prefixes="math dyn str">

<xsl:variable name="nl">
<xsl:text>
</xsl:text>
</xsl:variable>
<xsl:variable name="dot" select="' • '"/>
<xsl:variable name="po-prefix" select="'po-'"/>
<xsl:variable name="true-false-replace" select="'truefals'"/>
<xsl:variable name="ellipsis" select="'⋯'"/>


<xsl:output encoding="UTF-8" method="text"/>
<xsl:variable name="maxNameLength" select="dyn:max(//domain, 'string-length(concat(../@id,translate(boolean(substring-after(@id,$po-prefix)),$true-false-replace,$dot),substring-after(@id,$po-prefix)))')" />
<xsl:variable name="maxTranslatedLength" select="string-length(dyn:sum(//domain/translated,'.'))" />
<xsl:variable name="maxFuzzzyLength" select="string-length(dyn:sum(//domain/fuzzy,'.'))" />
<xsl:variable name="maxUntranslatedLength" select="string-length(dyn:sum(//domain/untranslated,'.'))" />
<xsl:variable name="maxAllLength" select="string-length(dyn:sum(//domain/translated,'.')+dyn:sum(//domain/fuzzy,'.')+dyn:sum(//domain/untranslated,'.'))" />
<xsl:variable name="maxTodoLength" select="string-length(dyn:sum(//domain/fuzzy,'.')+dyn:sum(//domain/untranslated,'.'))" />


<xsl:template match="/">
<!-- DEBUG -->
<!--
<xsl:value-of select="$maxNameLength"/>@maxNameLength
<xsl:value-of select="$maxTranslatedLength" />@maxTranslatedLength
<xsl:value-of select="$maxFuzzzyLength"/>@maxFuzzzyLength
<xsl:value-of select="$maxUntranslatedLength"/>@maxUntranslatedLength
<xsl:value-of select="$maxAllLength"/>@maxAllLength
<xsl:value-of select="$maxTodoLength"/>@maxTodoLength
-->
<xsl:call-template name="draw-table">
<xsl:with-param name="type" select="'full'"/>
</xsl:call-template>
<xsl:value-of select="$nl"/>
<xsl:value-of select="$nl"/>
<xsl:value-of select="$nl"/>
<xsl:value-of select="$nl"/>
<xsl:value-of select="$nl"/>
<xsl:call-template name="draw-table">
<xsl:with-param name="type" select="'short'"/>
</xsl:call-template>
</xsl:template>


<xsl:template name="draw-table">
<xsl:param name="type" select="'full'"/><!-- or 'short' -->
<!-- DEBUG -->
<!--
<xsl:value-of select="$type"/>#type
-->
<xsl:if test="($type != 'full') and ($type != 'short')">
<xsl:message>ПРОБЛЕМ В ПОДАДЕНИЯ ПАРАМЕТЪР НА draw-table</xsl:message>
</xsl:if>

<xsl:variable name="minTodoShown">
<xsl:choose>
<xsl:when test="$type = 'full'">0</xsl:when>
<xsl:otherwise>1</xsl:otherwise>
</xsl:choose>
</xsl:variable>

<xsl:variable name="ellipsisLine">
<xsl:choose>
<xsl:when test="$type = 'full'"/>
<xsl:otherwise>
<xsl:call-template name="draw-ellipsis"/>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>

<!-- DEBUG -->
<!--
<xsl:value-of select="$minTodoShown"/>#minTodoShown
<xsl:value-of select="$ellipsisLine"/>#ellipsisLine
-->

<xsl:call-template name="draw-heading"/>
<xsl:call-template name="draw-separator"/>

<xsl:for-each select="//domain[fuzzy + untranslated >= $minTodoShown]">
<xsl:sort order="descending" select="fuzzy + untranslated" data-type="number"/>
<xsl:sort order="descending" select="untranslated" data-type="number"/>
<xsl:sort order="descending" select="translated + fuzzy + untranslated" data-type="number"/>
<xsl:sort order="ascending" select="../@id"/>


<xsl:call-template name="draw-line">
<xsl:with-param name="name" select="concat(../@id,translate(boolean(substring-after(@id,$po-prefix)),$true-false-replace,$dot),substring-after(@id,$po-prefix))"/>
<xsl:with-param name="nameLength" select="$maxNameLength"/>
<xsl:with-param name="translated" select="translated"/>
<xsl:with-param name="translatedLength" select="$maxTranslatedLength"/>
<xsl:with-param name="fuzzy" select="fuzzy"/>
<xsl:with-param name="fuzzyLength" select="$maxFuzzzyLength"/>
<xsl:with-param name="untranslated" select="untranslated"/>
<xsl:with-param name="untranslatedLength" select="$maxUntranslatedLength"/>
<xsl:with-param name="all" select="translated+fuzzy+untranslated"/>
<xsl:with-param name="allLength" select="$maxAllLength"/>
<xsl:with-param name="todo" select="fuzzy+untranslated"/>
<xsl:with-param name="todoLength" select="$maxTodoLength"/>
<xsl:with-param name="separator" select="'|'"/>
<xsl:with-param name="pad" select="' '"/>
</xsl:call-template>


</xsl:for-each>

<xsl:value-of select="$ellipsisLine"/>

<xsl:call-template name="draw-separator"/>
<xsl:call-template name="draw-footer"/>
</xsl:template>

<xsl:template name="draw-line">
<xsl:param name="name"/>
<xsl:param name="nameLength"/>
<xsl:param name="translated"/>
<xsl:param name="translatedLength"/>
<xsl:param name="fuzzy"/>
<xsl:param name="fuzzyLength"/>
<xsl:param name="untranslated"/>
<xsl:param name="untranslatedLength"/>
<xsl:param name="all"/>
<xsl:param name="allLength"/>
<xsl:param name="todo"/>
<xsl:param name="todoLength"/>
<xsl:param name="separator"/>
<xsl:param name="pad"/>

<!-- DEBUG -->
<!--
<xsl:value-of select="$name"/>#name
<xsl:value-of select="$nameLength"/>#nameLength
<xsl:value-of select="$translated"/>#translated
<xsl:value-of select="$translatedLength"/>#translatedLength
<xsl:value-of select="$fuzzy"/>#fuzzy
<xsl:value-of select="$fuzzyLength"/>#fuzzyLength
<xsl:value-of select="$untranslated"/>#untranslated
<xsl:value-of select="$untranslatedLength"/>#untranslatedLength
<xsl:value-of select="$all"/>#all
<xsl:value-of select="$allLength"/>#allLength
<xsl:value-of select="$todo"/>#todo
<xsl:value-of select="$todoLength"/>#todoLength
<xsl:value-of select="$separator"/>#separator
<xsl:value-of select="$pad"/>#pad
-->


<xsl:value-of select="str:align($name,str:padding($nameLength+2,$pad),'left')"/>
<xsl:value-of select="$separator"/>
<xsl:value-of select="str:align($todo,str:padding($todoLength+2,$pad),'right')"/>
<xsl:value-of select="$separator"/>
<xsl:value-of select="str:align($untranslated,str:padding($untranslatedLength+2,$pad),'right')"/>
<xsl:value-of select="$separator"/>
<xsl:value-of select="str:align($fuzzy,str:padding($fuzzyLength+2,$pad),'right')"/>
<xsl:value-of select="$separator"/>
<xsl:value-of select="str:align($translated,str:padding($translatedLength+2,$pad),'right')"/>
<xsl:value-of select="$separator"/>
<xsl:value-of select="str:align($all,str:padding($allLength+2,$pad),'right')"/>
<xsl:value-of select="$nl"/>


</xsl:template>


<xsl:template name="draw-separator">
<xsl:call-template name="draw-line">
<xsl:with-param name="name" select="''"/>
<xsl:with-param name="nameLength" select="$maxNameLength"/>
<xsl:with-param name="translated" select="''"/>
<xsl:with-param name="translatedLength" select="$maxTranslatedLength"/>
<xsl:with-param name="fuzzy" select="''"/>
<xsl:with-param name="fuzzyLength" select="$maxFuzzzyLength"/>
<xsl:with-param name="untranslated" select="''"/>
<xsl:with-param name="untranslatedLength" select="$maxUntranslatedLength"/>
<xsl:with-param name="all" select="''"/>
<xsl:with-param name="allLength" select="$maxAllLength"/>
<xsl:with-param name="todo" select="''"/>
<xsl:with-param name="todoLength" select="$maxTodoLength"/>
<xsl:with-param name="separator" select="'+'"/>
<xsl:with-param name="pad" select="'-'"/>
</xsl:call-template>
</xsl:template>

<xsl:template name="draw-heading">
<xsl:call-template name="draw-line">
<xsl:with-param name="name" select="'Име'"/>
<xsl:with-param name="nameLength" select="$maxNameLength"/>
<xsl:with-param name="translated" select="'Преведени'"/>
<xsl:with-param name="translatedLength" select="$maxTranslatedLength"/>
<xsl:with-param name="fuzzy" select="'Мъгляви'"/>
<xsl:with-param name="fuzzyLength" select="$maxFuzzzyLength"/>
<xsl:with-param name="untranslated" select="'Непреведени'"/>
<xsl:with-param name="untranslatedLength" select="$maxUntranslatedLength"/>
<xsl:with-param name="all" select="'Всичко'"/>
<xsl:with-param name="allLength" select="$maxAllLength"/>
<xsl:with-param name="todo" select="'Работа'"/>
<xsl:with-param name="todoLength" select="$maxTodoLength"/>
<xsl:with-param name="separator" select="'|'"/>
<xsl:with-param name="pad" select="' '"/>
</xsl:call-template>
</xsl:template>


<xsl:template name="draw-footer">
<xsl:call-template name="draw-line">
<xsl:with-param name="name" select="'Общо'"/>
<xsl:with-param name="nameLength" select="$maxNameLength"/>
<xsl:with-param name="translated" select="dyn:sum(//domain/translated,'.')"/>
<xsl:with-param name="translatedLength" select="$maxTranslatedLength"/>
<xsl:with-param name="fuzzy" select="dyn:sum(//domain/fuzzy,'.')"/>
<xsl:with-param name="fuzzyLength" select="$maxFuzzzyLength"/>
<xsl:with-param name="untranslated" select="dyn:sum(//domain/untranslated,'.')"/>
<xsl:with-param name="untranslatedLength" select="$maxUntranslatedLength"/>
<xsl:with-param name="all" select="dyn:sum(//domain/translated,'.')+dyn:sum(//domain/fuzzy,'.')+dyn:sum(//domain/untranslated,'.')"/>
<xsl:with-param name="allLength" select="$maxAllLength"/>
<xsl:with-param name="todo" select="dyn:sum(//domain/fuzzy,'.')+dyn:sum(//domain/untranslated,'.')"/>
<xsl:with-param name="todoLength" select="$maxTodoLength"/>
<xsl:with-param name="separator" select="'|'"/>
<xsl:with-param name="pad" select="' '"/>
</xsl:call-template>
</xsl:template>

<xsl:template name="draw-ellipsis">
<xsl:call-template name="draw-line">
<xsl:with-param name="name" select="''"/>
<xsl:with-param name="nameLength" select="$maxNameLength"/>
<xsl:with-param name="translated" select="''"/>
<xsl:with-param name="translatedLength" select="$maxTranslatedLength"/>
<xsl:with-param name="fuzzy" select="''"/>
<xsl:with-param name="fuzzyLength" select="$maxFuzzzyLength"/>
<xsl:with-param name="untranslated" select="''"/>
<xsl:with-param name="untranslatedLength" select="$maxUntranslatedLength"/>
<xsl:with-param name="all" select="''"/>
<xsl:with-param name="allLength" select="$maxAllLength"/>
<xsl:with-param name="todo" select="''"/>
<xsl:with-param name="todoLength" select="$maxTodoLength"/>
<xsl:with-param name="separator" select="'|'"/>
<xsl:with-param name="pad" select="$ellipsis"/>
</xsl:call-template>
</xsl:template>

</xsl:stylesheet>
