#!/bin/bash
ENVIRONMENT=gtp
TRACDIR=/var/local/trac
ENVIRONMENTDIR=$TRACDIR/$ENVIRONMENT
BACKUPDIR=/home/ash/public_html
DATE=`date +%Y%m%d`
TRACHOTCOPYDIR=$BACKUPDIR/trac-$ENVIRONMENT-$DATE
TRACBACKUPFILE=$TRACHOTCOPYDIR.tar.bz2
TRACBACKUPFILEBARE=`basename $TRACBACKUPFILE`
MAILSUCCESS=dict-notifications@fsa-bg.org
MAILFAIL=dict@fsa-bg.org

# hotcopy
trac-admin $ENVIRONMENTDIR hotcopy $TRACHOTCOPYDIR
if [ "x$?" != "x0" ]; then
  ALARM="Cannot hotcopy $ENVIRONMENTDIR to $TRACHOTCOPYDIR"
fi

# tar.bz2
tar cfj $TRACBACKUPFILE $TRACHOTCOPYDIR
if [ "x$?" != "x0" ]; then
  ALARM=`echo "$ALARM"`"
Cannot create archive $TRACBACKUPFILE from $TRACHOTCOPYDIR"
fi

# rm dir
rm -fr $TRACHOTCOPYDIR
if [ "x$?" != "x0" ]; then
  ALARM=`echo "$ALARM"`"
Cannot remove dir $TRACHOTCOPYDIR"
fi

if [ "x$ALARM" != "x" ]; then 
MESSAGE="
On $DATE
The backup of the trac http://zver.fsa-bg.org/project/$ENVIRONMENT
Which resides in $ENVIRONMENTDIR
To $TRACBACKUPFILE
FAILED!
Please check and fix things!
ALARM:
$ALARM
"
mail -s "$DATE: Backup of $ENVIRONMENT TRAC on fsa-bg.org FAILED!" $MAILFAIL <<EOF
===================
$MESSAGE
===================
EOF
 else mail -s "$DATE: Backup of trac $ENVIRONMENT on fsa-bg.org succeeded!" $MAILSUCCESS <<EOF
===================
On $DATE
The backup of the trac http://zver.fsa-bg.org/gtp/$ENVIRONMENT
Which resides in /var/local/trac/$ENVIRONMENT
To $TRACBACKUPFILE
Succeeded.
Please copy the generated file from
http://zver.fsa-bg.org/~ash/$TRACBACKUPFILEBARE
===================
EOF
fi

